/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;

public class PropertySetCollection {
    private static String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    private Vector resultVector = new Vector();
    private String searchBaseDN = null;
    private NamingEnumeration resultSet = null;
    private boolean converted = false;

    protected PropertySetCollection() {
        this.converted = true;
    }

    protected PropertySetCollection(String string, NamingEnumeration namingEnumeration) {
        this(string, namingEnumeration, true);
    }

    protected PropertySetCollection(String string, NamingEnumeration namingEnumeration, boolean bl) {
        this.searchBaseDN = string;
        this.resultSet = namingEnumeration;
        if (bl) {
            this.convert();
        }
    }

    public final boolean isEmpty() {
        this.convert();
        return this.resultVector.isEmpty();
    }

    public final int size() {
        this.convert();
        return this.resultVector.size();
    }

    public final String[] getDns() {
        this.convert();
        String[] stringArray = new String[this.resultVector.size()];
        int n = 0;
        while (n < this.resultVector.size()) {
            stringArray[n] = ((PropertySet)this.resultVector.elementAt(n)).getDN();
            ++n;
        }
        return stringArray;
    }

    public final PropertySet getPropertySet(int n) {
        this.convert();
        return (PropertySet)this.resultVector.elementAt(n);
    }

    public final PropertySet getPropertySet(String string) {
        try {
            this.convert();
            String string2 = null;
            string2 = OUILdap.normalizeDN(string);
            int n = 0;
            while (n < this.resultVector.size()) {
                if (string2.equals(OUILdap.normalizeDN(((PropertySet)this.resultVector.elementAt(n)).getDN()))) {
                    return this.getPropertySet(n);
                }
                ++n;
            }
            return new PropertySet();
        }
        catch (UtilException utilException) {
            return null;
        }
    }

    final void add(PropertySet propertySet) {
        this.convert();
        this.resultVector.addElement(propertySet);
    }

    final PropertySet remove(int n) {
        this.convert();
        PropertySet propertySet = (PropertySet)this.resultVector.elementAt(n);
        this.resultVector.removeElementAt(n);
        return propertySet;
    }

    final Vector toVector() {
        this.convert();
        return (Vector)this.resultVector.clone();
    }

    private void convert() {
        if (!this.converted) {
            try {
                if (this.resultSet != null) {
                    while (this.resultSet.hasMore()) {
                        SearchResult searchResult = (SearchResult)this.resultSet.next();
                        PropertySet propertySet = new PropertySet(this.searchBaseDN, searchResult);
                        this.resultVector.addElement(propertySet);
                    }
                }
                this.converted = true;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }
}

